#!/bin/bash

actzTrace "XSETNETT: editFirewallChain $*"

op=$1
chain=$2
ifname=$3
protocol=$4
sourceAddr=$5
sourceAddrMask=$6
port=$7

if [ -x /sbin/iptables ]; then
    iptables=/sbin/iptables
elif [ -x /usr/sbin/iptables ]; then
    iptables=/usr/sbin/iptables
else
    actzTrace "XSETNETF: editFirewallChain: No iptables executable found."
    exit 0
fi

if [ "$protocol" = "icmp" ]; then
    cmd="$iptables $op $chain --in-interface \"$ifname\" --protocol $protocol --source $sourceAddr/$sourceAddrMask --icmp-type $port --jump ACCEPT --verbose"
elif echo $port | grep ","; then
    # there are multiple ports specified.. use the 'multiport' module
    cmd="$iptables $op $chain --match multiport --in-interface \"$ifname\" --protocol $protocol --source $sourceAddr/$sourceAddrMask --destination-ports $port --jump ACCEPT --verbose"
else
    cmd="$iptables $op $chain --in-interface \"$ifname\" --protocol $protocol --source $sourceAddr/$sourceAddrMask --destination-port $port --jump ACCEPT --verbose"
fi

actzTrace "XSETNETF: executing cmd: '$cmd'"

eval $cmd

rc=$?

actzTrace "XSETNETF: <- editFirewallChain: rc=$rc"

exit $rc
